<?php

namespace App\Http\Controllers;

use App\Models\Prize as PrizeModel;
use Illuminate\Http\Request;
use Illuminate\Http\Response;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Validator;

class Prize extends Controller
{
    /**
     * @param Request $request
     * @return array|\Illuminate\Http\JsonResponse
     */
    public function take(Request $request)
    {
        try {

            $action = $request->get('action');

            if($action === 'only-sort'){
                $validatedData = Validator::make(
                    $request->all(),
                    PrizeModel::rulesTakeOnlySort(),
                    PrizeModel::messagesTake()
                );

            }else{
                $validatedData = Validator::make(
                    $request->all(),
                    PrizeModel::rulesTake(),
                    PrizeModel::messagesTake()
                );

            }

            if ($validatedData->fails()) {
                return response()->json([
                    'message' => array_values($validatedData->errors()->toArray())
                ], Response::HTTP_BAD_REQUEST);
            }


            $size_orange = $request->get('number_orange') ? count($request->get('number_orange')) : 0;
            $size_green = $request->get('number_green') ? count($request->get('number_green')) : 0;
            $size_purple = $request->get('number_purple') ? count($request->get('number_purple')) : 0;

            $total_size = $size_orange + $size_green + $size_purple;

            //so the total must be > 1 and < 5 balls and if we have a purple we should have green as well
            if(!($total_size > 1 && $total_size < 6 ) || ($size_purple === 1 && $size_green === 0)){
                return response()->json([
                    'message' => [trans('api-response.prize-fix-error')]
                ], Response::HTTP_BAD_REQUEST);
            }

            $result = $this->prize($size_orange, $size_green, $size_purple, $request, $action);

            //dd('result : ', $result);
            if($result['error']){
                return response()->json([
                    'message' => [trans('api-response.prize-fix-error')]
                ], Response::HTTP_OK);
            }

            $save_prize = new PrizeModel();
            $save_prize->orange_pick_number = $result['orange_take'];
            $save_prize->orange_prize_draw = $result['orange_prize'];

            $save_prize->green_pick_number = $result['green_take'];
            $save_prize->green_prize_draw = $result['green_prize'];

            $save_prize->purple_pick_number = $result['purple_take'];
            $save_prize->purple_prize_draw = $result['purple_prize'];

            $save_prize->fix = ($action === 'fix-sort');


            $save_prize->win = ( $result['win'] && $action !== 'only-sort');
            $save_prize->save();




            if($action === 'fix-sort'){
                $data = ['fix-sort' => true];
            }else{
                $data = [   'prize_orange' => $result['orange_prize'],
                            'prize_green' => $result['green_prize'],
                            'prize_purple' => $result['purple_prize']
                        ];
            }

            if($result['win'] && $action !== 'only-sort'){
                return response()->json([
                    'data' => $data,
                    'message' => [trans('api-response.prize-congratulation-success')],
                    'display_message' => true
                ], Response::HTTP_OK);
            }

            return response()->json([
                'data' => $data,
                'message' => [trans('api-response.prize-success')],
                'display_message' => !($action === 'only-sort')
            ], Response::HTTP_OK);

        } catch (Exception $e) {
            return response()->json([
                'message' => ['Error: take prize.']
            ], Response::HTTP_BAD_GATEWAY);
        }
    }

    /**
     * @param Request $request
     * @return array|\Illuminate\Http\JsonResponse
     */
    public function listPrize(Request $request)
    {
        try {

            $data = PrizeModel::all();
            return response()->json([
                'data' => $data,
                'message' => [trans('api-response.prize-load-success')]
            ], Response::HTTP_OK);

        } catch (Exception $e) {
            return response()->json([
                'message' => ['Error: list prize.']
            ], Response::HTTP_BAD_GATEWAY);
        }
    }

    /**
     * @param $size_orange
     * @param $size_green
     * @param $size_purple
     * @param $request
     * @param $action
     * @return array
     */
    protected function prize($size_orange, $size_green, $size_purple, $request, $action){

        $result = [ 'win' => true, 'orange_take' => '', 'green_take' => '', 'purple_take' => '', 'error' => false];

        $arr_orange = $request->get('number_orange') ? $request->get('number_orange') : [];
        $arr_green = $request->get('number_green') ? $request->get('number_green') : [];
        $arr_purple = $request->get('number_purple') ? $request->get('number_purple'): [];

        $total_size = $size_orange + $size_green + $size_purple;
        $rand_number = [];

        if(!isset($fix_prize)){
            for ($i=0; $i<$total_size; $i++){
                while (true){
                    $rand = rand ( 1, 16);
                    if(!in_array($rand, $rand_number)){
                        $rand_number[] = $rand;
                        break;
                    }
                }
            }
        }

        if($action === 'fix-sort'){
            $prize = DB::table('fix_prizes')->where(['size' => $size_orange])->first();

            if($prize){

                $result['orange_prize'] = $prize->orange_prize_draw;

                $result['green_prize'] = $prize->green_prize_draw;

                $result['purple_prize'] = $prize->purple_prize_draw;

                $r = empty($prize->orange_prize_draw) ? '' : $prize->orange_prize_draw;
                $r .= empty($prize->green_prize_draw) ? '' : ' '.$prize->green_prize_draw;
                $r .= empty($prize->purple_prize_draw) ? '' : ' '.$prize->purple_prize_draw;

                $rand_number = explode(' ', $r);

            }else{
                $result['error'] = true;
                return $result;
            }


        }

        $orange_prize_slice = array_slice($rand_number,0, $size_orange);
        $green_prize_slice = $size_green ? array_slice($rand_number,$size_orange , $size_green) : [];
        $purple_prize_slice = $size_purple ?  array_slice($rand_number,$size_orange + $size_green , $size_purple) : [];

        if($action === 'only-sort'){
            $result['orange_prize'] = implode(' ', $orange_prize_slice);
            $result['green_prize'] = $size_green ? implode(' ', $green_prize_slice) : '';
            $result['purple_prize'] = $size_purple ? implode(' ', $purple_prize_slice) : '';
            return $result;
        }

        if($action === 'stick-sort' || $action === 'random-sort'){
            $result['orange_prize'] = implode(' ', $orange_prize_slice);
            $result['green_prize'] = $size_green ? implode(' ', $green_prize_slice) : '';
            $result['purple_prize'] = $size_purple ? implode(' ', $purple_prize_slice) : '';
        }

        $orange_match = $this->checkPrizeWin($arr_orange, $orange_prize_slice);
        $green_match = $this->checkPrizeWin($arr_green, $green_prize_slice);
        $purple_match = $this->checkPrizeWin($arr_purple, $purple_prize_slice);

        $result['orange_take'] = implode(' ', $arr_orange);
        $result['green_take'] = $size_green ? implode(' ', $arr_green) : '';
        $result['purple_take'] = $size_purple ? implode(' ', $arr_purple) : '';

        $result['win'] = $orange_match && $green_match && $purple_match;
        return $result;
    }

    protected function checkPrizeWin($number, $rand_number){
        if(count($number)>0){
            //check if win
            foreach ($number as $v){
                if(!in_array($v, $rand_number)){
                    return false;
                }
            }
        }
        return true;
    }
}
