<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Prize extends Model
{
    use HasFactory;

    /**
     * The table associated with the model.
     *
     * @var string
     */
    protected $table = 'user_action';

    /**
     * Max orange ball
     *
     * @var string
     */
    protected static $max_orange = 5;

    /**
     * Min orange ball
     *
     * @var string
     */
    protected static $min_orange = 1;

    /**
     * Max green ball
     *
     * @var string
     */
    protected static $max_green = 1;

    /**
     * Max purple ball
     *
     * @var string
     */
    protected static $max_purple = 1;

    /**
     * Min number ball
     *
     * @var string
     */
    protected static $min_number_ball = 1;

    /**
     * Max number ball
     *
     * @var string
     */
    protected static $max_number_ball = 16;


    /**
     * The rules to register user.
     *
     * @return  array
     */
    static function rulesTake(){
        return [
            'action' => 'required|in:only-sort,random-sort,fix-sort,stick-sort',
            'number_orange' => 'required|array|min:' . self::$min_orange . '|max:'.self::$max_orange,
            'number_orange.*' => 'required|distinct|min:' . self::$min_number_ball . '|max:' . self::$max_number_ball . '|numeric',
            'number_green' => 'array|max:'.self::$max_green,
            'number_green.*' => 'required|distinct|min:' . self::$min_number_ball . '|max:' . self::$max_number_ball . '|numeric',
            'number_purple' => 'array|max:'.self::$max_purple,
            'number_purple.*' => 'required|distinct|min:' . self::$min_number_ball . '|max:' . self::$max_number_ball . '|numeric'
        ];
    }

    /**
     * The rules to register user.
     *
     * @return  array
     */
    static function rulesTakeOnlySort(){
        return [
            'number_orange' => 'array|min:' . self::$min_orange . '|max:'.self::$max_orange,
            'number_green' => 'array|max:'.self::$max_green,
            'number_purple' => 'array|max:'.self::$max_purple
        ];
    }

    /**
     * The messages to register user.
     *
     * @return  array
     */
    static function messagesTake(){
        return [
            'action.required' => 'Please select one of the options bellow, blue buttons.',
            'action.in' => 'Wrong action.',
            'number_orange.required' => 'Please select orange balls.',
            'number_orange.*.numeric' => 'Please select numbers between ' . self::$min_number_ball . ' and ' . self::$max_number_ball . '.',
            'number_orange.*.min' => 'Please select numbers between ' . self::$min_number_ball . ' and ' . self::$max_number_ball . '.',
            'number_orange.*.max' => 'Please select numbers between ' . self::$min_number_ball . ' and ' . self::$max_number_ball . '.',
            'number_orange.min' => 'Please select at least ' . self::$min_orange . ' orange balls.',
            'number_orange.max' => 'You cannot select more than ' . self::$max_orange . ' orange balls.',
            'number_orange.*.distinct' => 'You cannot repeat numbers balls.',

            'number_green.required' => 'Please select numbers between ' . self::$min_number_ball . ' and ' . self::$max_number_ball . '.',
            'number_green.*.numeric' => 'Please select numbers between ' . self::$min_number_ball . ' and ' . self::$max_number_ball . '.',
            'number_green.*.min' => 'Please select numbers between ' . self::$min_number_ball . ' and ' . self::$max_number_ball . '.',
            'number_green.*.max' => 'Please select numbers between ' . self::$min_number_ball . ' and ' . self::$max_number_ball . '.',
            'number_green.max' => 'You cannot select more than ' . self::$max_green . ' green balls.',
            'number_green.*.distinct' => 'You cannot repeat numbers balls.',

            'number_purple.required' => 'Please select numbers between ' . self::$min_number_ball . ' and ' . self::$max_number_ball . '.',
            'number_purple.*.numeric' => 'Please select numbers between ' . self::$min_number_ball . ' and ' . self::$max_number_ball . '.',
            'number_purple.*.min' => 'Please select numbers between ' . self::$min_number_ball . ' and ' . self::$max_number_ball . '.',
            'number_purple.*.max' => 'Please select numbers between ' . self::$min_number_ball . ' and ' . self::$max_number_ball . '.',
            'number_purple.max' => 'You cannot select more than ' . self::$max_purple . ' purple balls.',
            'number_purple.*.distinct' => 'You cannot repeat numbers balls.'
        ];
    }
}
