<?php
/**
 * Created by PhpStorm.
 * User: carlos.costa
 * Date: 20/02/2018
 * Time: 22:38
 */

if (! function_exists('short_message')) {

    /**
     * @param $message
     * @param $length
     * @return mixed
     */
    function short_message($message,$length = null)
    {
        $length_default = 50;

        if($length){
            $length_default = $length;
        }

        $result = substr($message,0,$length_default);

        if(strlen($result)>=$length_default){
            $result.="...";
        }

        return $result;
    }

}

if (! function_exists('auto_version')) {
    /**
     * Assign high numeric IDs to a config item to force appending.
     *
     * @param  string  $file
     * @return mixed
     */
    function auto_version($file)
    {


        if(env('APP_ENV') === 'production'){
            $result_path = '/home/forexrob/madeira-poly.com/public_html/public/'.$file;
            if(file_exists($result_path)){
                return '/'.$file."?v=".filemtime($result_path);
            }
        }else{
            $result_path = public_path().'/'.$file;
            if(file_exists($result_path)){
                return $file."?v=".filemtime($result_path);
            }
        }


        return $result_path;
    }
}


if (! function_exists('split_word')) {
    /**
     * Split a word for paragraphs
     *
     * @param string $string
     * @return string
     */
    function split_word($string)
    {

        $split_word = explode(' ', $string);
        $return = '';

        foreach ($split_word as $val){
            $trim = trim($val);
            if($trim!=''){
                $return.= '<p>'.$trim.'</p>';
            }
        }

        return $return;
    }
}
