<?php

use App\Http\Controllers\Prize;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| is assigned the "api" middleware group. Enjoy building your API!
|
*/

Route::middleware('api')
    ->group(function() {
        Route::prefix('v' . env('API_VERSION', '1.0.0'))
            ->group(function() {

                //user group
                Route::prefix('user')->group(function() {
                    Route::post('prize', [Prize::class, 'take']);
                    Route::get('prize-list', [Prize::class, 'listPrize']);
                });


                Route::any('/{any}', function() {
                    //handle events
                    //TODO: LOG ANY FAIL CALL API
                    return new Response([
                        'message' => ['Prize draw API Endpoint not found - if this problem persists, please contact web developer.'],
                    ], Response::HTTP_NOT_FOUND);
                })->where('any', '.*');
            });
    });
